'use strict';

function QuotesCtrl($scope, $rootScope, QuotesManager){
    $scope.GpwTypes = QuotesManager.loadGpwTypesList();
    $scope.currentGpwType = {};
    $scope.currentDate = new Date();

    $scope.selectGpwType = function(GpwType){
        GpwType.getSessions(function(){
            $scope.currentGpwType = GpwType;
        });
    }

    $scope.getChangeSessionForIndex = function(GpwIndex){
        if( isNaN(parseFloat(GpwIndex.prevSession.close)) || isNaN(parseFloat(GpwIndex.prevSession.close))){
            return 0;
        }
        return parseFloat(GpwIndex.actualSession.close)/parseFloat(GpwIndex.prevSession.close)*100 - 100;
    }
}

QuotesCtrl.$inject = ['$scope', '$rootScope', 'QuotesManager'];